/*
 * Decompiled with CFR 0.152.
 */
package org.docbook.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.docbook.gradle.DocBookExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010,\u001a\u00020-H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00170\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\nR\u0014\u0010\u001c\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000eR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0019R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0!8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R \u0010$\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020%0\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0019R\u001a\u0010'\u001a\t\u0018\u00010(\u00a2\u0006\u0002\b)8G\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006."}, d2={"Lorg/docbook/gradle/DocBookPipeline;", "Lorg/gradle/api/DefaultTask;", "ex", "Lorg/gradle/process/ExecOperations;", "<init>", "(Lorg/gradle/process/ExecOperations;)V", "mainClass", "Lorg/gradle/api/provider/Property;", "", "getMainClass", "()Lorg/gradle/api/provider/Property;", "config", "Lorg/gradle/api/file/RegularFileProperty;", "getConfig", "()Lorg/gradle/api/file/RegularFileProperty;", "pipeline", "getPipeline", "sourcePort", "getSourcePort", "source", "getSource", "sourceMap", "Lorg/gradle/api/provider/MapProperty;", "Ljava/io/File;", "getSourceMap", "()Lorg/gradle/api/provider/MapProperty;", "resultPort", "getResultPort", "result", "getResult", "resultMap", "getResultMap", "options", "Lorg/gradle/api/provider/ListProperty;", "getOptions", "()Lorg/gradle/api/provider/ListProperty;", "params", "", "getParams", "docbookExt", "Lorg/docbook/gradle/DocBookExtension;", "Lorg/jspecify/annotations/Nullable;", "getDocbookExt", "()Lorg/docbook/gradle/DocBookExtension;", "runPipeline", "", "xsltng-gradle"})
public abstract class DocBookPipeline
extends DefaultTask {
    @NotNull
    private final ExecOperations ex;
    @Nullable
    private final DocBookExtension docbookExt;

    @Inject
    public DocBookPipeline(@NotNull ExecOperations ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        this.ex = ex;
        this.docbookExt = (DocBookExtension)this.getProject().getExtensions().findByType(DocBookExtension.class);
    }

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getMainClass();

    @InputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getConfig();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getPipeline();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getSourcePort();

    @InputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getSource();

    @Input
    @Optional
    @NotNull
    public abstract MapProperty<String, File> getSourceMap();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getResultPort();

    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getResult();

    @OutputFiles
    @Optional
    @NotNull
    public abstract MapProperty<String, String> getResultMap();

    @Input
    @NotNull
    public abstract ListProperty<String> getOptions();

    @Input
    @NotNull
    public abstract MapProperty<String, Object> getParams();

    @Internal
    @Nullable
    public final DocBookExtension getDocbookExt() {
        return this.docbookExt;
    }

    @TaskAction
    public final void runPipeline() {
        Object filename;
        String port;
        String string;
        RegularFile configPath;
        if (this.docbookExt == null) {
            throw new GradleException("Could not find 'docbook' extension");
        }
        Intrinsics.checkNotNull((Object)this.docbookExt, (String)"null cannot be cast to non-null type org.docbook.gradle.DocBookExtension");
        ProjectLayout projectLayout = ((Project)this.docbookExt.getProject().get()).getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"getLayout(...)");
        ProjectLayout layout = projectLayout;
        RegularFile regularFile = configPath = this.getConfig().getOrNull() == null ? (RegularFile)this.docbookExt.getPipelineConfiguration().getOrNull() : (RegularFile)this.getConfig().get();
        if (this.getSource().getOrNull() != null) {
            Object object = this.getSourceMap().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            if (!((Map)object).isEmpty()) {
                throw new GradleException("Only one of 'source' or 'sourceMap' is allowed");
            }
        }
        if (this.getResult().getOrNull() != null) {
            Object object = this.getResultMap().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            if (!((Map)object).isEmpty()) {
                throw new GradleException("Only one of 'result' or 'resultMap' is allowed");
            }
        }
        if ((string = (String)this.getMainClass().getOrNull()) == null) {
            Object object = this.docbookExt.getPipelineClass().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            string = (String)object;
        }
        String javaClass = string;
        List argList = new ArrayList();
        argList.add(String.valueOf(this.getPipeline().get()));
        if (configPath != null) {
            argList.add("--config:" + configPath);
        }
        argList.add("--init:org.docbook.xsltng.extensions.Register");
        if (this.getSource().getOrNull() != null) {
            String string2 = (String)this.getSourcePort().getOrNull();
            if (string2 == null) {
                Object object = this.docbookExt.getPipelineSourcePort().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                string2 = (String)object;
            }
            argList.add("-i:" + string2 + "=" + this.getSource().get());
        } else {
            Object object = this.getSourceMap().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            for (Map.Entry entry : ((Map)object).entrySet()) {
                Object k = entry.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
                port = (String)k;
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
                filename = (File)v;
                argList.add("-i:" + port + "=" + (File)filename);
            }
        }
        if (this.getResult().getOrNull() != null) {
            String string3 = (String)this.getResultPort().getOrNull();
            if (string3 == null) {
                Object object = this.docbookExt.getPipelineResultPort().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                string3 = (String)object;
            }
            argList.add("-o:" + string3 + "=" + this.getResult().get());
        } else {
            Object object = this.getResultMap().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            for (Map.Entry entry : ((Map)object).entrySet()) {
                Object k = entry.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
                port = (String)k;
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
                filename = (String)v;
                argList.add("-o:" + port + "=" + (String)filename);
            }
        }
        Object object = this.getOptions().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        argList.addAll((Collection)object);
        Object object2 = this.getParams().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        for (Map.Entry entry : ((Map)object2).entrySet()) {
            Object pvalue;
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            String pkey = (String)k;
            Intrinsics.checkNotNullExpressionValue(entry.getValue(), (String)"component2(...)");
            if (pvalue instanceof Map) {
                for (Map.Entry entry2 : ((Map)pvalue).entrySet()) {
                    Object pskey = entry2.getKey();
                    Object psvalue = entry2.getValue();
                    argList.add(pkey + "::" + pskey + "=" + psvalue);
                }
                continue;
            }
            argList.add(pkey + "=" + pvalue);
        }
        if (((Boolean)this.docbookExt.getDebug().get()).booleanValue()) {
            System.out.println((Object)(javaClass + " " + CollectionsKt.joinToString$default((Iterable)argList, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
        }
        this.ex.javaexec(new Action(this, javaClass, argList){
            final /* synthetic */ DocBookPipeline this$0;
            final /* synthetic */ String $javaClass;
            final /* synthetic */ List<String> $argList;
            {
                this.this$0 = $receiver;
                this.$javaClass = $javaClass;
                this.$argList = $argList;
            }

            public final void execute(JavaExecSpec $this$javaexec) {
                Intrinsics.checkNotNullParameter((Object)$this$javaexec, (String)"$this$javaexec");
                $this$javaexec.setClasspath((FileCollection)this.this$0.getDocbookExt().getClasspath().get());
                $this$javaexec.getMainClass().set((Object)this.$javaClass);
                $this$javaexec.args((Iterable)this.$argList);
            }
        });
    }
}

