/*
 * Decompiled with CFR 0.152.
 */
package org.docbook.gradle;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.docbook.gradle.DocBookExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\"\u001a\u00020#H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00148gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00188gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00188gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u001a\u0010\u001d\u001a\t\u0018\u00010\u001e\u00a2\u0006\u0002\b\u001f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006$"}, d2={"Lorg/docbook/gradle/DocBookTransform;", "Lorg/gradle/api/DefaultTask;", "ex", "Lorg/gradle/process/ExecOperations;", "<init>", "(Lorg/gradle/process/ExecOperations;)V", "config", "Lorg/gradle/api/provider/Property;", "", "getConfig", "()Lorg/gradle/api/provider/Property;", "source", "Lorg/gradle/api/file/RegularFileProperty;", "getSource", "()Lorg/gradle/api/file/RegularFileProperty;", "stylesheet", "getStylesheet", "result", "getResult", "options", "Lorg/gradle/api/provider/ListProperty;", "getOptions", "()Lorg/gradle/api/provider/ListProperty;", "params", "Lorg/gradle/api/provider/MapProperty;", "getParams", "()Lorg/gradle/api/provider/MapProperty;", "staticParams", "getStaticParams", "docbookExt", "Lorg/docbook/gradle/DocBookExtension;", "Lorg/jspecify/annotations/Nullable;", "getDocbookExt", "()Lorg/docbook/gradle/DocBookExtension;", "runPipeline", "", "gradle-plugin"})
public abstract class DocBookTransform
extends DefaultTask {
    @NotNull
    private final ExecOperations ex;
    @Nullable
    private final DocBookExtension docbookExt;

    @Inject
    public DocBookTransform(@NotNull ExecOperations ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        this.ex = ex;
        this.docbookExt = (DocBookExtension)this.getProject().getExtensions().findByType(DocBookExtension.class);
        this.getConfig().convention((Object)"config.xml");
    }

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getConfig();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getSource();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getStylesheet();

    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getResult();

    @Input
    @NotNull
    public abstract ListProperty<String> getOptions();

    @Input
    @NotNull
    public abstract MapProperty<String, String> getParams();

    @Input
    @NotNull
    public abstract MapProperty<String, String> getStaticParams();

    @Internal
    @Nullable
    public final DocBookExtension getDocbookExt() {
        return this.docbookExt;
    }

    @TaskAction
    public final void runPipeline() {
        Object object;
        if (this.docbookExt == null) {
            throw new GradleException("Could not find 'docbook' extension");
        }
        Intrinsics.checkNotNull((Object)this.docbookExt, (String)"null cannot be cast to non-null type org.docbook.gradle.DocBookExtension");
        ProjectLayout projectLayout = ((Project)this.docbookExt.getProject().get()).getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"getLayout(...)");
        ProjectLayout layout = projectLayout;
        if (Intrinsics.areEqual((Object)this.getConfig().get(), (Object)"config.xml")) {
            var3_2 = layout.getProjectDirectory().file("src/config.xml");
            Intrinsics.checkNotNull((Object)var3_2);
            object = var3_2;
        } else {
            var3_2 = this.getConfig().get();
            Intrinsics.checkNotNull((Object)var3_2);
            object = var3_2;
        }
        Object configPath = object;
        List argList = new ArrayList();
        argList.add(String.valueOf(layout.getProjectDirectory().file("tools/xpl/style.xpl")));
        argList.add("--config:" + configPath);
        argList.add("--init:org.docbook.xsltng.extensions.Register");
        argList.add("-i:source=" + this.getSource().get());
        argList.add("-i:stylesheet=" + this.getStylesheet().get());
        if (this.getResult().getOrNull() != null) {
            argList.add("-o:result=" + this.getResult().get());
        }
        Object object2 = this.getParams().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        for (Map.Entry entry : ((Map)object2).entrySet()) {
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            String pkey = (String)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            String pvalue = (String)v;
            argList.add("parameters::" + pkey + "=" + pvalue);
        }
        this.ex.javaexec(new Action(this, argList){
            final /* synthetic */ DocBookTransform this$0;
            final /* synthetic */ List<String> $argList;
            {
                this.this$0 = $receiver;
                this.$argList = $argList;
            }

            public final void execute(JavaExecSpec $this$javaexec) {
                Intrinsics.checkNotNullParameter((Object)$this$javaexec, (String)"$this$javaexec");
                $this$javaexec.setClasspath((FileCollection)this.this$0.getDocbookExt().getClasspath().get());
                $this$javaexec.getMainClass().set((Object)"com.xmlcalabash.app.Main");
                $this$javaexec.args((Iterable)this.$argList);
            }
        });
    }
}

